/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.persist.impl;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.service.persist.GenericPersistence;
import com.ibm.hwmca.fw.service.persist.PersistentObjectControl;
import com.ibm.hwmca.fw.service.persist.PersistentObjectDescriptor;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TTLObjectControl
implements PersistentObjectControl {
    public static int NO_LIMIT = -1;
    int daysToLive;
    long milliSecsToLive;

    public TTLObjectControl(int daysToLive) {
        if (daysToLive < 0) {
            this.daysToLive = NO_LIMIT;
        } else {
            this.daysToLive = daysToLive;
            this.milliSecsToLive = daysToLive * 24 * 60 * 60 * 1000;
        }
    }

    public TTLObjectControl() {
        this.daysToLive = NO_LIMIT;
    }

    public void filterAll(GenericPersistence gp, Map keyMap) throws PersistenceException {
        Set keys = keyMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.filter(gp, keyMap, (String)it.next());
        }
    }

    public void filter(GenericPersistence gp, Map keyMap, String uniqueId) throws PersistenceException {
        Object o;
        if (this.daysToLive != NO_LIMIT && keyMap.containsKey(uniqueId) && (o = keyMap.get(uniqueId)) instanceof ObjectDescriptor) {
            ObjectDescriptor pd = (ObjectDescriptor)o;
            long currentTime = new Date().getTime();
            if (pd.creationTime + this.milliSecsToLive < currentTime) {
                gp.remove(uniqueId);
            }
        }
    }

    public PersistentObjectDescriptor createObjectDescriptor(String persistentId, Persistable persistable) {
        return new ObjectDescriptor(persistentId);
    }

    private static class ObjectDescriptor
    extends PersistentObjectDescriptor {
        public long creationTime = new Date().getTime();

        public ObjectDescriptor(String persistentId) {
            super(persistentId);
        }
    }
}

